#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <time.h>
#include <unistd.h>

#define VEHICLES_NUM 30

#define CAR 0
#define BUS 1
#define TRUCK 2

#define LEFT_DIR 0
#define RIGHT_DIR 1
#define NO_DIR -1

typedef struct {
    int id;
    int dir;
    int type;
} vehicle_t;

pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t cond = PTHREAD_COND_INITIALIZER;

int current_dir = NO_DIR;
int waiting_left = 0;
int waiting_right = 0;
int n_on_bridge = 0;
int bus_on_bridge = 0;
int truck_on_bridge = 0;

void *work(void *arg) {
    vehicle_t *vehicle = (vehicle_t *)arg;
    sleep(rand() % 20 + 1);
    printf("Vozilo %d,\tTip %s,\tStrana %s,\tstize pred nadvoznjak.\n", vehicle->id, vehicle->type != 0 ? (vehicle->type == 1 ? "AUTOBUS" : "KAMION") : "AUTOMOBIL",vehicle->dir ? "DESNA" : "LEVA");

    pthread_mutex_lock(&mutex);
    vehicle->dir == LEFT_DIR ? waiting_left++ : waiting_right++;

    while ((current_dir != NO_DIR && vehicle->dir != current_dir) || 
    (
        vehicle->dir == current_dir && (
            truck_on_bridge > 0 || 
            (vehicle->type == BUS && bus_on_bridge > 0) ||
            (vehicle->type == TRUCK && n_on_bridge > 0) 
        )
    )) {
        pthread_cond_wait(&cond, &mutex);
    }
    current_dir = vehicle->dir;
    n_on_bridge++;
    vehicle->dir == LEFT_DIR ? waiting_left-- : waiting_right--;
    
    if (vehicle->type == BUS) {
        bus_on_bridge = 1;
    } else if (vehicle->type == TRUCK) {
        truck_on_bridge = 1;
    }

    printf("Vozilo %d,\tTip %s,\tStrana %s,\tpocinje sa prelazenjem nadvoznjaka.\n", vehicle->id, vehicle->type != 0 ? (vehicle->type == 1 ? "AUTOBUS" : "KAMION") : "AUTOMOBIL",vehicle->dir ? "DESNA" : "LEVA");
    pthread_mutex_unlock(&mutex);

    sleep(rand() % 3 + 1);

    pthread_mutex_lock(&mutex);
    n_on_bridge--;

    if (vehicle->type == BUS) {
        bus_on_bridge = 0;
    } else if (vehicle->type == TRUCK) {
        truck_on_bridge = 0;
    }
    
    printf("Vozilo %d,\tTip %s,\tStrana %s,\t je presao nadvoznjak.\n", vehicle->id, vehicle->type != 0 ? (vehicle->type == 1 ? "AUTOBUS" : "KAMION") : "AUTOMOBIL",vehicle->dir ? "DESNA" : "LEVA");

    if (n_on_bridge == 0) {
        if ((current_dir == LEFT_DIR && waiting_left > 0) ||
            (current_dir == RIGHT_DIR && waiting_left > 0)
        ) {
            current_dir = NO_DIR;
            pthread_cond_broadcast(&cond);       
        }
    }
    pthread_mutex_unlock(&mutex);

    return NULL;
}

int main() {
    srand(time(NULL));

    pthread_t threads[VEHICLES_NUM];
    vehicle_t vehicles[VEHICLES_NUM];

    for (int i = 0; i < VEHICLES_NUM; i++) {
        vehicles[i].id = i;
        vehicles[i].dir = rand() % 2;
        vehicles[i].type = rand() % 3;
        pthread_create(threads + i, NULL, work, vehicles + i);
    }
    
    for (int i = 0; i < VEHICLES_NUM; i++) {    
        pthread_join(threads[i], NULL);
    }

    return 0;
}